/*
 * Decompiled with CFR 0.152.
 */
package com.webcodepro.applecommander.ui.swt.util.contentadapter;

import com.webcodepro.applecommander.ui.swt.util.SwtUtil;
import com.webcodepro.applecommander.ui.swt.util.contentadapter.ContentTypeAdapter;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.StyledTextPrintOptions;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.printing.Printer;

public class StyledTextAdapter
implements ContentTypeAdapter {
    private StyledText styledText;
    private String printJobName;

    public StyledTextAdapter(StyledText styledText, String printJobName) {
        this.styledText = styledText;
        this.printJobName = printJobName;
    }

    @Override
    public void print() {
        final Printer printer = SwtUtil.showPrintDialog(this.styledText);
        if (printer == null) {
            return;
        }
        StyledTextPrintOptions options = new StyledTextPrintOptions();
        options.jobName = this.printJobName;
        options.printLineBackground = true;
        options.printTextBackground = true;
        options.printTextFontStyle = true;
        options.printTextForeground = true;
        options.footer = "\t<page>";
        options.header = "\t" + this.printJobName;
        final Runnable runnable = this.styledText.print(printer, options);
        new Thread(new Runnable(){

            @Override
            public void run() {
                runnable.run();
                printer.dispose();
            }
        }).start();
    }

    @Override
    public void selectAll() {
        this.styledText.selectAll();
    }

    @Override
    public void copy() {
        if (this.styledText.getSelectionCount() == 0) {
            Point selection = this.styledText.getSelection();
            this.styledText.selectAll();
            this.styledText.copy();
            this.styledText.setSelection(selection);
        } else {
            this.styledText.copy();
        }
    }
}

